import java.awt.*;
import javax.swing.*;

/** This class is used to demo the use of a Box. The comment
    on the constructor says how the frame is laid out.
  */
public class BoxDemo extends JFrame {

	/** Constructor: an invisible frame with title t, labels in the
	    east, a west, a blank label in the south, and a horizontal
	    Box with three buttons in the center. Change the Box
	    to a vertical box, as an experiment.
	  */
	public BoxDemo(String t) {
		super(t);
		
		Box b= new Box(BoxLayout.X_AXIS);        
		b.add(new JButton("first"));
		b.add(new JButton("second"));
		b.add(new JButton("third"));
	  
		Container cp= getContentPane();
		cp.add(new JLabel("WEST Label"), BorderLayout.WEST);
		cp.add(new JLabel("EAST Label"), BorderLayout.EAST);
		cp.add(new JLabel(" "), BorderLayout.SOUTH);
		
		cp.add(b, BorderLayout.CENTER);
		 
		pack();
	}
	
	public static void main(String[] args) {
		BoxDemo pd= new BoxDemo("demo JPanel");
		pd.setVisible(true);
	}

}
